package nemosofts.notes.app.activity;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.StrictMode;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import androidx.multidex.MultiDex;
import androidx.nemosofts.Application;
import androidx.nemosofts.Nemosofts;
import androidx.nemosofts.theme.ThemeEngine;

import com.google.firebase.analytics.FirebaseAnalytics;
import com.onesignal.OneSignal;

import nemosofts.notes.app.BuildConfig;
import nemosofts.notes.app.R;
import nemosofts.notes.app.callback.Callback;
import nemosofts.notes.app.constant.Constant;
import nemosofts.notes.app.utils.advertising.AppOpenAdManager;
import nemosofts.notes.app.utils.helper.DBHelper;
import nemosofts.notes.app.utils.helper.Helper;
import nemosofts.notes.app.utils.helper.SPHelper;

public class MyApplication extends Application implements android.app.Application.ActivityLifecycleCallbacks, DefaultLifecycleObserver {

    private AppOpenAdManager appOpenAdManager;
    private Activity currentActivity;

    @Override
    public void onCreate() {
        super.onCreate();

        this.registerActivityLifecycleCallbacks(this);
        ProcessLifecycleOwner.get().getLifecycle().addObserver(this);
        appOpenAdManager = new AppOpenAdManager(getApplicationContext());

        // Analytics Initialization
        FirebaseAnalytics.getInstance(getApplicationContext());

        StrictMode.VmPolicy.Builder builder = new StrictMode.VmPolicy.Builder();
        StrictMode.setVmPolicy(builder.build());

        // OneSignal Initialization
        OneSignal.initWithContext(getApplicationContext(), getString(R.string.onesignal_app_id));

        DBHelper dbHelper = new DBHelper(getApplicationContext());
        dbHelper.onCreate(dbHelper.getWritableDatabase());

        new Helper(getApplicationContext()).initializeAds();

        new Nemosofts(this).setVerificationCode(Constant.itemApp.getApikey());

        setThemeEngine();
    }

    @Override
    public String setProductID() {
        return "29610215";
    }

    @Override
    public String setApplicationID() {
        return BuildConfig.APPLICATION_ID;
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(this);
    }

    @Override
    public void onStart(@NonNull LifecycleOwner owner) {
        DefaultLifecycleObserver.super.onStart(owner);
        boolean start = Constant.itemApp.getIsOpenAd() && !Callback.getIsAppOpenAdShown();
        if (start) {
            appOpenAdManager.showAdIfAvailable(currentActivity);
        }
    }

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        // no data
    }

    @Override
    public void onActivityStarted(@NonNull Activity activity) {
        if (Boolean.FALSE.equals(appOpenAdManager.getIsShowingAd())) {
            currentActivity = activity;
        }
    }

    @Override
    public void onActivityResumed(@NonNull Activity activity) {
        // no data
    }

    @Override
    public void onActivityPaused(@NonNull Activity activity) {
        // no data
    }

    @Override
    public void onActivityStopped(@NonNull Activity activity) {
        // no data
    }

    @Override
    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        // no data
    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity) {
        // no data
    }

    public void loadAd(@NonNull Activity activity) {
        boolean load = Constant.itemApp.getIsOpenAd();
        if (load){
            appOpenAdManager.loadAd(activity);
        }
    }

    public AppOpenAdManager getAppOpenAdManager() {
        return appOpenAdManager;
    }

    private void setThemeEngine() {
        try {
            SPHelper spHelper =new SPHelper(getApplicationContext());
            if (Boolean.TRUE.equals(spHelper.getIsFirst())) {
                spHelper.setIsFirst(false);
                ThemeEngine themeEngine = new ThemeEngine(getApplicationContext());
                int nightModeFlags = getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK;
                if (nightModeFlags == Configuration.UI_MODE_NIGHT_YES){
                    if (themeEngine.getThemePage() != 2){
                        themeEngine.setThemeMode(true);
                        themeEngine.setThemePage(2);
                    }
                } else if (nightModeFlags == Configuration.UI_MODE_NIGHT_NO && themeEngine.getThemePage() != 0){
                    themeEngine.setThemeMode(false);
                    themeEngine.setThemePage(0);
                }
            }
        } catch (Exception e) {
            Log.e("MyApplication", "Error set theme engine", e);
        }
    }
}